package com.ejie.aa94a.model.config;

import java.io.Serializable;
import java.math.BigDecimal;

import org.springframework.context.i18n.LocaleContextHolder;

import com.ejie.aa94a.constantes.Constantes;

public class Densidad implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer codigo;
	private BigDecimal valor;
	private String descEs;
	private String descEu;

	/**
	 * 
	 */
	public Densidad() {
		super();
	}

	/**
	 * @param codigo
	 * @param valor
	 * @param descEs
	 * @param descEu
	 */
	public Densidad(int codigo, BigDecimal valor, String descEs, String descEu) {
		super();
		this.codigo = codigo;
		this.valor = valor;
		this.descEs = descEs;
		this.descEu = descEu;
	}

	/**
	 * 
	 * @return the codigo
	 */
	public int getCodigo() {
		return codigo;
	}

	/**
	 * @param codigo
	 *            the codigo to set
	 */
	public void setCodigo(int codigo) {
		this.codigo = codigo;
	}

	/**
	 * @return the valor
	 */
	public BigDecimal getValor() {
		return valor;
	}

	/**
	 * @param valor
	 *            the valor to set
	 */
	public void setValor(BigDecimal valor) {
		this.valor = valor;
	}

	/**
	 * @return the descEs
	 */
	public String getDescEs() {
		return descEs;
	}

	/**
	 * @param descEs
	 *            the descEs to set
	 */
	public void setDescEs(String descEs) {
		this.descEs = descEs;
	}

	/**
	 * @return the descEu
	 */
	public String getDescEu() {
		return descEu;
	}

	/**
	 * @param descEu
	 *            the descEu to set
	 */
	public void setDescEu(String descEu) {
		this.descEu = descEu;
	}

	/**
	 * Method 'getDesc'.
	 * 
	 * @return String
	 */
	public String getDesc() {
		if (Constantes.EU.equalsIgnoreCase(LocaleContextHolder.getLocale()
				.getLanguage())) {
			return this.getDescEu();
		}
		return this.getDescEs();
	}
}
